import openmatrix as omx
import openpyxl
import numpy as np

#Apertura del file OMX
OMXfile = omx.open_file('IMQ2013_zonecampionarie.omx',"r")
print("File OMX di riferimento: ",OMXfile.filename,"\n")

#Caricamento delle informazioni sulla mappatura (conversione cod. alfanumerico - cod. numerico)
excel_document = openpyxl.load_workbook('ZoneCampionarie2013.xlsx') 
nsheet = excel_document.sheetnames  
sheet = excel_document[nsheet[0]] 
zoneA = list()   
zoneN = np.zeros(209)
for j in range(0,209):
    zoneA.append(sheet.cell(row=j+2,column=2).value)
    zoneN[j] = sheet.cell(row=j+2,column=1).value    

#Definizione della funzione di riceca del valore nella matrice
def estrazioneValore(matrice,Z1,Z2):
    S1to2 = OMXfile[matrice][zoneA.index(Z1)][zoneA.index(Z2)]
    S2to1 = OMXfile[matrice][zoneA.index(Z2)][zoneA.index(Z1)]
    return (S1to2,S2to1)

#Ottemimento dei dati di ingresso 
zona1 = input("Inserire codice prima zona:\t")
zona2 = input("Inserire codice seconda zona:\t")
modo = input("Inserire il modo (Pr-privato, Pu-pubblico, T-totali): ")
per = input("Periodo (IG-intera giornata, OP-ora di punta): ")
if per == "IG":
    scopo = input("Scopo (t-tutti, sr-tutti escluso ritorno): ")
else: 
    scopo = 't'

#Ricerca delle informazioni e stampa a video dei risultati
if modo == "T":
    SPOST1to2 = 0
    SPOST2to1 = 0
    for md in ["Pr","Pu"]:
        (V1to2,V2to1) = estrazioneValore("ResPIEm"+md+per+scopo,zona1,zona2)
        SPOST1to2 = SPOST1to2+V1to2
        SPOST2to1 = SPOST2to1+V2to1
    print("\n- SPOSTAMENTI REGISTRATI TRA LE DUE ZONE -")
    print(zona1,"-->",zona2," = ",SPOST1to2)
    print(zona2,"-->",zona1," = ",SPOST2to1)    
    print("Matrici di riferimento: ","ResPIEmPu"+per+scopo,"/ ResPIEmPr"+per+scopo)
else: 
    (SPOST1to2,SPOST2to1) = estrazioneValore("ResPIEm"+modo+per+scopo,zona1,zona2)
    print("\n- SPOSTAMENTI REGISTRATI TRA LE DUE ZONE -")
    print(zona1,"-->",zona2," = ",SPOST1to2)
    print(zona2,"-->",zona1," = ",SPOST2to1)
    print("Matrice di riferimento: ","ResPIEm"+modo+per+scopo)

#Chiusura del file aperto
OMXfile.close()


